/**
 * De klasse Bankkaartlezer representeert een bankkaartlezer
 * die de weekenddeur van een bank opent via kaart.
 * 
 * @author Dominiek Vandewalle 
 * @version 2014-09-16
 */
public class Bankkaartlezer
{
    // velden
    private boolean open;//true als de deur open is, anders false
    private String bankcode;

    /**
     * Constructor voor objecten van de klasse Bankkaartlezer
     */
    public Bankkaartlezer(String bankcode)
    {
        // initialise instance variables
        this.bankcode = bankcode;
        open = false;
    }
    
    /**
     * De deur van de bank wordt geopend indien het IBAN-nr
     * van de bankkaart voldoet aan volgende zaken:
     * 1) 16 tekens lang en begin met BE
     * 2) De 12 laatste tekens zijn een geldig rekeningnr
     * 3) Van de 12 laatste tekens zijn de eerste drie de
     *      bankcode van de bank van deze kaartenlezer
     * Er verschijnen volgende boodschappen bij het al dan
     * niet slagen van de testen:
     * 1) "Geen Belgisch IBAN-nummer"
     * 2) "Geen geldig rekeningnummer"
     * 3) "Gebruik de geldautomaat buiten"
     * 4) "De deur is open"
     * 
     * @param  ibannr IBAN-rekeningnummer op de bankkaart.
     */
    public void openBankdeur(String ibannr)
    {

    }
    
    /**
     * Sluit de deur van de bank.
     */
    public void sluitBankdeur()
    {
        open = false;
    }
    
    /**
     * Haalt uit het IBAN-nr het rekeningnummer
     * en het controlegetal en controleert
     * of de rest bij deling van het rekeningnummer 
     * door 97 gelijk is aan het controlegetal
     * Voorbeeld BE68539007547034
     *      rekeningnr: 5390075470
     *      controlegetal: 34
     *      
     * @param  ibannr Een Belgisch ibannummer
     * @return     True indien een geldig nummer, false in het ander geval.
     */
    
    private boolean geldigRekeningNr(String ibannr)
    {
        int reknr;
        int controlegetal;
        
        //schrijf hieronder je eigen code.
        return false;
          
    }
}
